
********************************************
* (1) This generates the dependent variable
********************************************
set more off
xtset country_id period
gen bankingcrisis = recessions
gen start_crisis = 0 if bankingcrisis !=.
replace start_crisis = 1 if bankingcrisis == 1 & bankingcrisis[_n-1] == 0 // The start date of the crisis

* 5 year lead and lag of crisis start
forvalues i = 1(1)20 {
	gen start_crisisf`i' = f`i'.start_crisis
	gen start_crisisl`i' = l`i'.start_crisis
	}
	
sort country_id period

/* Generating a forward looking crisis variable taking the value one in the 3 year ///
   period preceding the crisis */

* Change horizons here if needed  
gen crisis = 0
forvalues i=1(1)12 {
	replace crisis = 1 if start_crisisf`i' == 1
	}
	replace crisis = . if bankingcrisis == 1 & crisis != 1
	
gen crisis4_12 = 0
forvalues i=4(1)12 {
	replace crisis4_12 = 1 if start_crisisf`i' == 1
	}
	replace crisis4_12 = . if bankingcrisis == 1 & crisis4_12 != 1 
	forvalues i=1(1)3 {
	replace crisis4_12 = . if start_crisisf`i' == 1
	}
	
	
gen crisis16 = 0
forvalues i=1(1)16 {
	replace crisis16 = 1 if start_crisisf`i' == 1
	}
	replace crisis16 = . if bankingcrisis == 1 & crisis16 != 1
	
	
gen crisis4_16 = 0
forvalues i=4(1)16 {
	replace crisis4_16 = 1 if start_crisisf`i' == 1
	}
	replace crisis4_16 = . if bankingcrisis == 1 & crisis4_16 != 1
	forvalues i=1(1)3 {
	replace crisis4_16 = . if start_crisisf`i' == 1
	}
	
gen crisis4_20 = 0
forvalues i=4(1)20 {
	replace crisis4_20 = 1 if start_crisisf`i' == 1
	}
	replace crisis4_20 = . if bankingcrisis == 1 & crisis4_20 != 1
	forvalues i=1(1)3 {
	replace crisis4_20 = . if start_crisisf`i' == 1
	}	
************************************	
* (2) Variables to be used in levels
************************************

* Generating banking sector capitalization variable 
xtset country_id period
tssmooth ma equity_assets = equity_ratio, window(3 1 0)
set more off
		
foreach var in hp_inc_gap exub_hp_inc exub_cred_g global_credit_gap global_hp_gap ///
			   ind_hp_inc_exu ind_credit_gdp_exu pcredit_gdp_gap hcredit_gdp_gap nfecredit_gdp_gap ///
			   wholesale_assets equity_ratio wholesale_gap gdp_gap {
				
			   gen `var'1 = l1.`var'
				}
		
* Giving labels to all variables	
label variable nGDP "Nominal GDP"
label variable rGDP "Real GDP"
label variable gdp_gap "GDP gap"
label variable hcredit_gdp "Household credit/GDP "
label variable hcredit_gdp_gap "Household credit/GDP gap"
label variable nfecredit_gdp "NFE credit/GDP "
label variable nfecredit_gdp_gap "NFE credit/GDP gap "
label variable wholesale_assets "Non-core funding ratio"
label variable wholesale_gap "Non-core funding gap"
label variable equity_assets "Equity ratio"
label variable pcredit "Nominal credit" 
label variable real_pcredit "Real credit" 
label variable pcredit_gdp "Total credit" 
label variable pcredit_gdp_gap "Credit/GDP gap"
label variable real_hp "Real house prises"
label variable hp_disp_inc "HP to disp. inc."
label variable hp_inc_gap "House prices to inc. gap"
label variable exub_hp_inc "HP to inc. exuberance"
label variable ind_hp_inc_exu "Exuberance HP to inc. (yes/no)"
label variable exub_cred_g "Credit to GDP exuberance"
label variable ind_credit_gdp_exu "Exuberance credit/gdp (yes/no)"
label variable global_real_credit "Global real credit growth"
label variable global_real_credit_equal "Global real credit growth (equal weights)"
label variable global_credit_gdp "Global credit/GDP"
label variable global_credit_gdp_equal "Global credit/GDP (equal weights)"
label variable global_credit_gap "Global credit/GDP gap"
label variable global_credit_gap_equal "Global credit/GDP gap (equal weights)"
label variable global_real_hp "Global real house price growth"
label variable global_real_hp_equal "Global real house price growth (equal weights)" 
label variable global_hp_inc "Global HP to inc."
label variable global_hp_inc_equal "Global HP to inc. (equal weights)"
label variable global_hp_gap "Global HP to inc. gap"
label variable global_hp_gap_equal "Global HP to inc. gap (equal weights)"



************************************	
* (3) 4-quarter growth rates
************************************

set more off
xtset country_id period
foreach var in pcredit real_pcredit real_hp hp_disp_inc global_credit_gdp rGDP nGDP ///
	           pcredit_gdp global_real_credit global_real_hp global_hp_inc nfecredit_gdp ///
			   hcredit_gdp wholesale_assets real_hcredit real_nfecredit hcredit nfecredit {
			   
	gen dlog`var' = log(`var')-log(l4.`var')
	gen dlog`var'1 = l1.dlog`var'
	}
	
	
	
* Labeling variables
label variable dlogpcredit "Private credit growth (yoy)"
label variable dlogreal_pcredit "Real credit growth (yoy)"
label variable dlogreal_hp "Real house price growth (yoy)" 
label variable dloghp_disp_inc "House prices to inc. growth (yoy)"
label variable dlogglobal_credit_gdp "Glo. Credit/GDP growth (yoy)"
label variable dlogglobal_real_credit "Glo. Real credit growth (yoy)"
label variable dlogglobal_real_hp "Glo. Real house price growth (yoy)"
label variable dlogglobal_hp_inc "Glo. HP to inc. growth (yoy)"
label variable dloghcredit "Household credit growth (yoy)"
label variable dlognfecredit "NFE credit growth (yoy)"
label variable dlognGDP "Nominal GDP growth (yoy)"
label variable dlogpcredit_gdp "Private credit/GDP growth (yoy)"
label variable dlognfecredit_gdp "NFE credit/GDP growth (yoy)"
label variable dloghcredit_gdp "Household credit/GDP growth (yoy)"
label variable dlogwholesale_assets "Non-core/assets growth(yoy)"

label variable dlogreal_pcredit1 "Real credit growth (yoy)"
label variable dlogreal_hp1 "Real house price growth (yoy)" 
label variable dloghp_disp_inc1 "House prices to inc. growth (yoy)"
label variable dlogglobal_credit_gdp1 "Glo. Credit/GDP growth (yoy)"
label variable dlogglobal_real_credit1 "Glo. Real credit growth (yoy)"
label variable dlogglobal_real_hp1 "Glo. Real house price growth (yoy)"
label variable dlogglobal_hp_inc1 "Glo. HP to inc. growth (yoy)"
label variable dloghcredit1 "Household credit growth (yoy)"
label variable dlognfecredit1 "NFE credit growth (yoy)"
label variable dlognGDP1 "Nominal GDP growth (yoy)"
label variable dlogpcredit_gdp1 "Private credit/GDP growth (yoy)"
label variable dlognfecredit_gdp1 "NFE credit/GDP growth (yoy)"
label variable dloghcredit_gdp1 "Household credit/GDP growth (yoy)"
label variable dlogwholesale_assets1 "Non-core/assets growth(yoy)"


	
foreach var in pcredit_gdp nfecredit_gdp hcredit_gdp hp_disp_inc wholesale_assets {
		gen d`var' = `var' - l4.`var'
		}
		
label variable dpcredit_gdp "Private credit to GDP (yd)"
label variable dhcredit_gdp "Household credit to GDP (yd)"
label variable dnfecredit_gdp "NFE credit to GDP (yd)"
label variable dhp_disp_inc "House prices to income (yd)"
label variable dwholesale_assets "Non-core/assets (yd)"



